<?php

namespace Modules\Order\Services;

use App\Helpers\PaymentGatewayCredential;
use Auth;
use Illuminate\Http\RedirectResponse;

class PaymentGatewayService
{
    private const CANCEL_ROUTE = 'frontend.order.payment.cancel';
    private const SUCCESS_ROUTE = 'frontend.order.payment.success';
    public function payment_with_gateway($payment_gateway_name,$request, $order_id,$total)
    {
        try {
            $payment_gateway_name = strtolower($payment_gateway_name);
            $gateway_function = 'get_' . $payment_gateway_name . '_credential';
            $gateway = PaymentGatewayCredential::$gateway_function();

            return $gateway->charge_customer(
                $this->common_charge_customer_data($payment_gateway_name,$request, $order_id,$total)
            );
        } catch (\Exception $e) {
            return back()->with(['msg' => $e->getMessage(), 'type' => 'danger']);
        }
    }

    public function common_charge_customer_data($payment_gateway_name, $request, $order_id,$total): array
    {
        $user = Auth::guard('web')->user() ?? null;
        $email = $user->email ?? $request["email"];
        $name = $user->name ?? $request["name"];

        return [
            'amount' => $total,
            'title' => __("Payment for order"),
            'description' => __("Payment For Order Id:") .  "#" . $order_id ." ". __("Payer Name:") . $name ." , ". __("Email:") . $email ,
            'ipn_url' => route('frontend.' . strtolower($payment_gateway_name) . '.ipn', $order_id),
            'order_id' => $order_id,
            'track' => \Str::random(36),
            'cancel_url' => route(self::CANCEL_ROUTE, $order_id),
            'success_url' => route(self::SUCCESS_ROUTE, $order_id),
            'email' => $email,
            'name' => $name,
            'payment_type' => 'order',
        ];
    }

    // IPNs
    public function paypal_ipn()
    {
        $paypal = PaymentGatewayCredential::get_paypal_credential();
        $payment_data = $paypal->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function paytm_ipn()
    {
        $paytm = PaymentGatewayCredential::get_paytm_credential();
        $payment_data = $paytm->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function flutterwave_ipn()
    {
        $flutterwave = PaymentGatewayCredential::get_flutterwave_credential();
        $payment_data = $flutterwave->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function stripe_ipn()
    {
        $stripe = PaymentGatewayCredential::get_stripe_credential();
        $payment_data = $stripe->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function razorpay_ipn()
    {
        $razorpay = PaymentGatewayCredential::get_razorpay_credential();
        $payment_data = $razorpay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function paystack_ipn()
    {
        $paystack = PaymentGatewayCredential::get_paystack_credential();
        $payment_data = $paystack->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function payfast_ipn()
    {
        $payfast = PaymentGatewayCredential::get_payfast_credential();
        $payment_data = $payfast->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function mollie_ipn()
    {
        $mollie = PaymentGatewayCredential::get_mollie_credential();
        $payment_data = $mollie->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function midtrans_ipn()
    {
        $midtrans = PaymentGatewayCredential::get_midtrans_credential();
        $payment_data = $midtrans->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function cashfree_ipn()
    {
        $cashfree = PaymentGatewayCredential::get_cashfree_credential();
        $payment_data = $cashfree->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function instamojo_ipn()
    {
        $instamojo = PaymentGatewayCredential::get_instamojo_credential();
        $payment_data = $instamojo->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function mercadopago_ipn()
    {
        $mercadopago = PaymentGatewayCredential::get_mercadopago_credential();
        $payment_data = $mercadopago->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function squareup_ipn()
    {
        $squareup = PaymentGatewayCredential::get_squareup_credential();
        $payment_data = $squareup->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function cinetpay_ipn()
    {
        $cinetpay = PaymentGatewayCredential::get_cinetpay_credential();
        $payment_data = $cinetpay->ipn_response();

        return $this->common_ipn_data($payment_data);
    }
    public function paytabs_ipn()
    {
        $paytabs = PaymentGatewayCredential::get_paytabs_credential();
        $payment_data = $paytabs->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function billplz_ipn()
    {
        $billplz = PaymentGatewayCredential::get_billplz_credential();
        $payment_data = $billplz->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function zitopay_ipn()
    {
        $zitopay = PaymentGatewayCredential::get_zitopay_credential();
        $payment_data = $zitopay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function toyyibpay_ipn()
    {
        $toyyibpay = PaymentGatewayCredential::get_toyyibpay_credential();
        $payment_data = $toyyibpay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function pagali_ipn()
    {
        $pagalipay = PaymentGatewayCredential::get_pagali_credential();
        $payment_data = $pagalipay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function authorizenet_ipn()
    {
        $authorizenet = PaymentGatewayCredential::get_authorizenet_credential();
        $payment_data = $authorizenet->ipn_response();

        return $this->common_ipn_data($payment_data);
    }
    public function siteways_ipn()
    {
        $siteways = PaymentGatewayCredential::get_siteways_credential();
        $payment_data = $siteways->ipn_response();

        return $this->common_ipn_data($payment_data);
    }
    public function transactionclud_ipn()
    {
        $transactionclud = PaymentGatewayCredential::get_transactionclud_credential();
        $payment_data = $transactionclud->ipn_response();

        return $this->common_ipn_data($payment_data);
    }
    public function wipay_ipn()
    {
        $wipay = PaymentGatewayCredential::get_wipay_credential();
        $payment_data = $wipay->ipn_response();

        return $this->common_ipn_data($payment_data);
    }

    public function senangpay_ipn()
    {
        $senangpay = PaymentGatewayCredential::get_senangpay_credential();
        $payment_data = $senangpay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function iyzipay_ipn()
    {
        $iyzipay = PaymentGatewayCredential::get_iyzipay_credential();
        $payment_data = $iyzipay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }
    public function awdpay_ipn()
    {
        $awdpay = PaymentGatewayCredential::get_awdpay_credential();
        $payment_data = $awdpay->ipn_response();
        return $this->common_ipn_data($payment_data);
    }

    public function sslcommerz_ipn()
    {
        $sslcommerz = PaymentGatewayCredential::get_sslcommerz_credential();
        $payment_data = $sslcommerz->ipn_response();

        return $this->common_ipn_data($payment_data);
    }


    private function common_ipn_data($payment_data)
    {
        if (isset($payment_data['status']) && $payment_data['status'] === 'complete') {
            try {
                $this->update_database($payment_data['order_id'], $payment_data['transaction_id']);
                $this->send_order_mail($payment_data['order_id']);
                $this->tenant_create_event_with_credential_mail($payment_data['order_id']);
                $this->update_tenant($payment_data);

            } catch (\Exception $exception) {
                $message = $exception->getMessage();
                if(str_contains($message,'Access denied')){
                    if(request()->ajax()){
                        abort(462,__('Database created failed, Make sure your database user has permission to create database'));
                    }
                }

                $payment_details = PaymentLogs::where('id',$payment_data['order_id'])->first();
                if(empty($payment_details))
                {
                    abort(462,__('Does not exist, Tenant does not exists'));
                }
                LandlordPricePlanAndTenantCreate::store_exception($payment_details->tenant_id,'Domain create',$exception->getMessage(), 0);

                //todo: send an email to admin that this user databse could not able to create automatically

                try {
                    $message = sprintf(__('Database Creating failed for user id %1$s , please checkout admin panel and generate database for this user from admin panel manually'),
                        $payment_details->user_id);
                    $subject = sprintf(__('Database Crating failed for user id %1$s'),$payment_details->user_id);
                    Mail::to(get_static_option('site_global_email'))->send(new BasicMail($message,$subject));

                } catch (\Exception $e) {
                    LandlordPricePlanAndTenantCreate::store_exception($payment_details->tenant_id,'domain failed email',$e->getMessage(), 0);
                }
            }

            $order_id = wrap_random_number($payment_data['order_id']);
            return redirect()->route(self::SUCCESS_ROUTE, $order_id);
        }

        return $this->cancel_page();
    }

    private function update_database($order_id, $transaction_id)
    {
        PaymentLogs::where('id', $order_id)->update([
            'transaction_id' => $transaction_id,
            'status' => 'complete',
            'payment_status' => 'complete',
            'updated_at' => Carbon::now()
        ]);
    }
}