<?php

namespace App\Http\Requests\Admin\ShopManage;

use Illuminate\Foundation\Http\FormRequest;

class ShopManageUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'store_name' => 'required',
            'email' => 'nullable',
            'country_id' => 'nullable',
            'state_id' => 'nullable',
            'city' => 'nullable',
            'zipcode' => 'nullable',
            'number' => 'nullable',
            'address' => 'nullable',
            'location' => 'nullable',
            'facebook_url' => 'nullable',
            'logo_id' => 'required',
            'cover_photo_id' => 'nullable',
        ];
    }

    public function messages(): array
    {
        return [
            'logo_id.required' => 'Logo filed is required.',
        ]; //  Change the autogenerated stub
    }
}
