<?php

namespace App\Http\Services;

use App\MediaUpload;

class Media // Idea and generated by Md Zahidul Islam
{
    const DEFAULT_IMAGE_PATH = "assets/img/chat/avatar.svg";

    /**
     * @param string|object|null $image
     * @param string $size
     * @param string $render_type
     * @param string $class
     * @param string $attribute
     * @param string $file_type
     * @param bool $defaultImage
     * @param string $custom_path
     * @return string|null
     */
    public static function render_image(string|object|null $image, string $size = "grid", string $render_type = 'tag', string $class = '', string $attribute = '' , string $file_type = "image",bool $defaultImage = false, string $custom_path = ''): ?string
    {
        // this condition of line will check image is empty and defaultImage is false then it will return null
        if(empty($image) && !$defaultImage) return null;

        // render custom path file with custom url and render image or anything
        if (gettype($image) == 'string' && !empty($custom_path)){
            return self::check_render_type(type: $render_type,image: url($custom_path. '/' . $image),alt: '',class: $class, attribute: $attribute);
        }

        // this condition will check if defaultImage is true and image is empty then return default user avatar
        if ($defaultImage && empty($image)){
            return self::check_render_type(type: $render_type,image: asset(self::DEFAULT_IMAGE_PATH),alt: $image->alt ?? '',class: $class, attribute: $attribute);
        }

        $path = url("assets/uploads/media-uploader/");
        // check file type
        if(self::check_file_type($file_type)){
            if(gettype($image) == 'string' || gettype($image) == 'integer'){
                $image = MediaUpload::find($image);
            }
            $path = self::check_media_size($size,$image->path ?? '',$path);

            return self::check_render_type(type: $render_type,image: $path,alt: $image->alt ?? '',class: $class, attribute: $attribute);
        }

        return null;
    }

    private static function check_file_type($type): bool
    {
        // check a media file type
        return match($type){
            'image' => true,
            default => false,
        };
    }

    private static function check_media_size($size,$image,$path): string
    {
        $imagePath = $path . '/' . $image;
        // check file exists or not
        if(file_exists($imagePath)){
            return match ($size){
                'grid' => $path . "/grid-" . $image,
                'large' => $path . '/large-' . $image,
                'thumb' => $path . '/thumb-' . $image,
                'full' => $path . '/' . $image,
            };
        }else{
            return $path . '/' . $image;
        }
    }

    private static function check_render_type($type,$image,$alt,$class,$attribute): string
    {
        // check type and return value
        return match($type){
            'bg' => "background-image: url(" . $image . ");",
            'tag' => self::image_tag($image,$alt,$class,$attribute),
            'path', 'url' => $image,
        };
    }

    private static function image_tag($path, $alt, $class, $attributes): string
    {
        $fileExtension = pathinfo($path, PATHINFO_EXTENSION);
        $imageExtension = array('jpg','gif', 'JPG', 'png' ,'PNG' ,'jpeg' ,'JPEG','svg','SVG','webp','WEBP');

        if(in_array($fileExtension, $imageExtension)):
            return "<img alt='". $alt ."' src='" . $path . "' class='". $class ."' ". $attributes .">";
        else:
            return  "<a download href='" . $path . "' class='file-extension-image'><img src='" . self::fileExtensionImage($fileExtension) . "'  /></a>";
        endif;
    }

    private static function fileExtensionImage($ext): string
    {
        $file = match ($ext){
            'mp4','WebM' => 'video.png',
            'mp3','wav' => 'audio.png',
            'csv','xlcx' => 'xlsx.png',
            'zip','tar' => 'zip.png',
            'docx' => 'docx.png',
            'esp' => 'esp.png',
            'txt' => 'txt.png',
            'ai' => 'ai.png',
            'psd' => 'psd.png',
            'pdf' => 'pdf.png',
            default => 'default.png'
        };

        return asset("assets/img/file-extension/" . $file);
    }
}