<?php $__env->startSection('site-title'); ?>
    <?php echo e(__('Add New User')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-lg-12 col-ml-12">
        <?php echo $__env->make('backend/partials/message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('backend/partials/error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
            <!-- basic form start -->
            <div class="col-12">
                <div class="dashboard__card">
                    <div class="dashboard__card__header">
                        <h4 class="dashboard__card__title"><?php echo e(__('New User')); ?></h4>
                    </div>
                    <div class="dashboard__card__body custom__form mt-4">
                        <form action="<?php echo e(route('admin.frontend.new.user')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="name"><?php echo e(__('Name')); ?></label>
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="<?php echo e(__('Enter name')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="username"><?php echo e(__('Username')); ?></label>
                                <input type="text" class="form-control" id="username" name="username"
                                    placeholder="<?php echo e(__('Username')); ?>">
                                <small
                                    class="text text-danger"><?php echo e(__('Remember this username, user will login using this username')); ?></small>
                            </div>
                            <div class="form-group">
                                <label for="email"><?php echo e(__('Email')); ?></label>
                                <input type="text" class="form-control" id="email" name="email"
                                    placeholder="<?php echo e(__('Email')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="phone"><?php echo e(__('Phone')); ?></label>
                                <input type="text" class="form-control" id="phone" name="phone"
                                    placeholder="<?php echo e(__('Phone')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="country"><?php echo e(__('Country')); ?></label>
                                
                                <select id="country" name="country">
                                    <option value=""><?php echo e(__("Select Country")); ?></option>
                                    <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>">
                                            <?php echo e($item->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="state"><?php echo e(__('State')); ?></label>
                                <select id="state_id" name="state">
                                    <option value=""><?php echo e(__("Select State")); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="city"><?php echo e(__('City')); ?></label>
                                <select id="city_id" name="city" >
                                    <option value=""><?php echo e(__("Select City")); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="zipcode"><?php echo e(__('Zipcode')); ?></label>
                                <input type="text" class="form-control" id="zipcode" name="zipcode"
                                    placeholder="<?php echo e(__('Zipcode')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="address"><?php echo e(__('Address')); ?></label>
                                <input type="text" class="form-control" id="address" name="address"
                                    placeholder="<?php echo e(__('Address')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="password"><?php echo e(__('Password')); ?></label>
                                <input type="password" class="form-control" id="password" name="password"
                                    placeholder="<?php echo e(__('Password')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="password_confirmation"><?php echo e(__('Password Confirm')); ?></label>
                                <input type="password" class="form-control" id="password_confirmation"
                                    name="password_confirmation" placeholder="<?php echo e(__('Password Confirmation')); ?>">
                            </div>
                            <button type="submit" class="cmn_btn btn_bg_profile mt-4"><?php echo e(__('Add New User')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
    $(document).on("change", "#country", function() {
            let data = new FormData();

            data.append("country_id", $(this).val());
            data.append("_token", "<?php echo e(csrf_token()); ?>");

            send_ajax_request("post", data, "<?php echo e(route('admin.vendor.get.state')); ?>", function() {}, (data) => {
                $("#state_id").html("<option value=''><?php echo e(__("Select an state")); ?></option>" + data.option);
                $(".state_wrapper .list").html(data.li);
            }, (data) => {
                prepare_errors(data);
            })
        });

        $(document).on("change", "#state_id", function() {
            let data = new FormData();

            data.append("country_id", $("#country").val());
            data.append("state_id", $(this).val());
            data.append("_token", "<?php echo e(csrf_token()); ?>");

            send_ajax_request("post", data, "<?php echo e(route('admin.vendor.get.city')); ?>", function() {}, (data) => {
                $("#city_id").html("<option value=''><?php echo e(__("Select an city")); ?></option>" + data.option);
                $(".city_wrapper .list").html(data.li);
            }, (data) => {
                prepare_errors(data);
            })
        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.admin-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demofilesco/public_html/hometex/core/Modules/User/Resources/views/backend/add-new-user.blade.php ENDPATH**/ ?>