<?php $__env->startSection('page-title', __('Vendor List Page')); ?>
<?php $__env->startSection('title', __('Vendor List Page')); ?>

<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Best Seller area Starts -->
    <section class="best-seller-area padding-top-100 padding-bottom-50">
        <div class="container container-one">
            <div class="row g-4">
                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $rating_width = round(($vendor->vendor_product_rating_avg_product_ratingsrating ?? 0) * 20);
                    ?>
                    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
                        <div class="best-seller-item center-text radius-10">
                            <div class="seller-thumb radius-10">
                                <a href="#1">
                                    <?php echo render_image($vendor->cover_photo); ?>

                                </a>
                            </div>
                            <a href="#1" class="thumb-brand radius-5 brand-thumb-border">
                                <?php echo render_image($vendor->logo); ?>

                            </a>
                            <div class="best-seller-contents mt-3">
                                <h5 class="common-title-two">
                                    <a href="<?php echo e(route('frontend.vendors.single', $vendor->username)); ?>">
                                        <?php echo e($vendor->business_name); ?> </a>
                                </h5>
                                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'd-flex',
                                    'justify-content-center' => $vendor->vendor_product_rating_count < 1,
                                    'justify-content-between' => $vendor->vendor_product_rating_count > 0,
                                ]); ?>">
                                    <div>
                                        <i class="las la-shopping-bag"></i>
                                        (<?php echo e($vendor->product_count); ?>)
                                    </div>

                                    <?php if($vendor->vendor_product_rating_count > 0): ?>
                                        <div class="rating-wrap">
                                            <div class="ratings">
                                                <span class="hide-rating"></span>
                                                <span class="show-rating"
                                                    style="width: <?php echo e($rating_width); ?>%!important"></span>
                                            </div>
                                            <div class="">
                                                <span class="total-ratings">
                                                    <?php echo e($vendor->vendor_product_rating_count ? '(' . $vendor->vendor_product_rating_count . ')' : ''); ?>

                                                </span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <a href="<?php echo e(route('frontend.vendors.single', $vendor->username)); ?>" class="btn-product mt-2"
                                    tabindex="0"> <?php echo e(__('Visit Store')); ?> <i class="las la-arrow-right"></i> </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Best Seller area end -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demofilesco/public_html/hometex/core/Modules/Vendor/Resources/views/frontend/vendors-page.blade.php ENDPATH**/ ?>