# Thamirabharani Engineering College - Dynamic Content Management System

This project implements a dynamic content management system for the Thamirabharani Engineering College website, allowing administrators to edit content for the About Us and Principal Desk pages through a user-friendly admin interface.

## Features

### 🎯 Dynamic Content Management
- **About Us Page**: Edit title, subtitle, description, vision, quality policy, experience years, and contact information
- **Principal Desk Page**: Edit principal's name, designation, welcome message, philosophy, courses information, and additional content
- **Real-time Updates**: Changes made through admin interface are immediately reflected on the public pages

### 🔧 Admin Interface
- **Dashboard**: Central hub for managing different page content
- **User-friendly Forms**: Intuitive forms with proper validation and error handling
- **Success Notifications**: Clear feedback when content is updated successfully
- **Preview Links**: Direct links to view the updated pages

### 🗄️ Database Management
- **MySQL Database**: Robust, scalable database for production use
- **Automatic Initialization**: Database tables are created automatically with default content
- **Content Versioning**: Each update creates a new record, maintaining content history
- **Connection Pooling**: Efficient database connection management

## Installation & Setup

### Prerequisites
- Node.js (v14 or higher)
- npm (Node Package Manager)
- MySQL Server (v5.7 or higher)

### Database Setup
1. **Create MySQL Database**
   ```sql
   CREATE DATABASE db_thamirabharani;
   ```

2. **Configure Environment Variables**
   Create a `.env` file in the project root with the following variables:
   ```env
   # Database Configuration
   DB_HOST=localhost
   DB_USER=root
   DB_PASSWORD=your_password
   DB_NAME=db_thamirabharani
   DB_PORT=3306
   
   # Server Configuration
   PORT=3000
   NODE_ENV=development
   ```

### Installation Steps

1. **Clone or download the project**
   ```bash
   cd thamirabharani
   ```

2. **Install dependencies**
   ```bash
   npm install
   ```

3. **Start the application**
   ```bash
   npm start
   ```
   
   Or for development with auto-restart:
   ```bash
   npm run dev
   ```

4. **Access the application**
   - Main website: http://localhost:3000
   - Admin dashboard: http://localhost:3000/admin

## Usage Guide

### Accessing Admin Interface
1. Navigate to `http://localhost:3000/admin`
2. You'll see the admin dashboard with options to edit different pages

### Editing About Us Page
1. Click "Edit About Page" from the admin dashboard
2. Fill in the form fields:
   - **Page Title**: Main title of the page
   - **Page Subtitle**: Subtitle text
   - **Main Description**: Primary description about the college
   - **Years of Experience**: Number of years the college has been operating
   - **Contact Phone**: Phone number for contact information
   - **Vision Statement**: College vision (supports HTML formatting)
   - **Quality Policy**: Quality policy statement
3. Click "Update Content" to save changes

### Editing Principal Desk Page
1. Click "Edit Principal Page" from the admin dashboard
2. Fill in the form fields:
   - **Principal Name**: Name and qualifications of the principal
   - **Designation**: Principal's designation
   - **Welcome Message**: Welcome message from the principal
   - **Educational Philosophy**: Principal's educational philosophy
   - **Courses Introduction**: Introduction text for courses section
   - **Courses List**: Comma-separated list of engineering courses
   - **Additional Content**: Additional content that appears below courses
3. Click "Update Content" to save changes

### Viewing Changes
- Use the "View Page" buttons in the admin interface to see your changes
- Changes are immediately reflected on the public pages

## Database Schema

### About Content Table
```sql
CREATE TABLE about_content (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255),
    subtitle VARCHAR(255),
    description TEXT,
    vision TEXT,
    quality_policy TEXT,
    experience_years INT,
    phone VARCHAR(50),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

### Principal Content Table
```sql
CREATE TABLE principal_content (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255),
    designation VARCHAR(255),
    welcome_message TEXT,
    philosophy TEXT,
    courses_description TEXT,
    courses_list TEXT,
    additional_content TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

## File Structure

```
thamirabharani/
├── app.js                          # Main application file
├── package.json                    # Dependencies and scripts
├── .env                           # Environment variables (create this)
├── public/                         # Static assets
│   ├── css/                       # Stylesheets
│   ├── js/                        # JavaScript files
│   └── images/                    # Images
├── views/                         # EJS templates
│   ├── common/                    # Common components
│   │   ├── header.ejs
│   │   └── footer.ejs
│   ├── admin/                     # Admin interface templates
│   │   ├── dashboard.ejs
│   │   ├── about-edit.ejs
│   │   └── principal-edit.ejs
│   ├── about.ejs                  # About page (dynamic)
│   ├── principal-desk.ejs         # Principal desk page (dynamic)
│   └── index.ejs                  # Home page
└── README.md                      # This file
```

## API Endpoints

### Public Routes
- `GET /` - Home page
- `GET /about-us` - About page (with dynamic content)
- `GET /principal-desk` - Principal desk page (with dynamic content)

### Admin Routes
- `GET /admin` - Admin dashboard
- `GET /admin/about` - About page edit form
- `POST /admin/about/update` - Update about page content
- `GET /admin/principal` - Principal page edit form
- `POST /admin/principal/update` - Update principal page content

## Security Considerations

- The current implementation is for demonstration purposes
- For production use, consider adding:
  - User authentication and authorization
  - Input validation and sanitization
  - CSRF protection
  - Rate limiting
  - HTTPS enforcement
  - Database connection encryption

## Customization

### Adding New Content Fields
1. Update the database schema in `app.js`
2. Modify the admin forms in the respective edit templates
3. Update the public page templates to display the new content
4. Add form handling in the POST routes

### Styling
- Admin interface uses Bootstrap for responsive design
- Custom CSS is included in each admin template
- Modify the `<style>` sections in admin templates to customize appearance

## Troubleshooting

### Common Issues

1. **Database connection failed**
   - Verify MySQL server is running
   - Check database credentials in `.env` file
   - Ensure database `db_thamirabharani` exists
   - Check MySQL user permissions

2. **Content not updating**
   - Verify form fields are properly named
   - Check browser console for JavaScript errors
   - Ensure all required fields are filled
   - Check MySQL connection logs

3. **Images not uploading**
   - Ensure the `public/images/` directory exists and is writable
   - Check file size limits in multer configuration

### Logs
- Application logs are displayed in the console when running the server
- Database errors are logged to the console
- Check the terminal output for error messages

## Future Enhancements

- User authentication system
- Content approval workflow
- Image upload and management
- Content versioning and rollback
- Rich text editor for content editing
- Backup and restore functionality
- Multi-language support
- Database migration scripts

## Support

For technical support or questions about the implementation, please refer to the code comments or create an issue in the project repository. 